# This script is intended to query the status of a service given a fragment or complete name
# The wildard (*) can be used to pick up by prefix.
#
# This script expects that you are passing in 4 parameters
#
# 1. The project Acronym.  Here at AITC that would be our three byte project identifier.  This 
#    script was specifically written for the VRK project.
# 2. The host name of the Introscope EP Agent that we will send metrics too.
# 3. The port number of the Introscope EP Agent that we will send metrics too.
# 4. Service or service fragment.  Provide exact name or use an asterisk as a wild card.  If you want 
#    to see everything that starts with "Win" you would provide Win*
#
# Example: Assumes that you are running from the location that the files are located.
#
#   c:\temp\powershell.exe -File ".\PowerShellServiceStatusQuery.ps1" BMS vaaacnms20.aac.va.gov 9090 WMI_UserGroup_Job Duration 10
# 
# Expectations for arguments passed in
# $args[0] -- Project
# $args[1] -- Reporting Host
# $args[2] -- Reporting Port
# $args[3] -- Scheduled Task Name
# $args[4] -- Name of Metric
# $args[5] -- Metric Value (assumes integer)

$metricURL = ("http://" + $args[1] + ":" + $args[2] + "/?metricType=IntCounter&metricName=PowerShell%7c" + $args[0] + "%7C" + $env:COMPUTERNAME + "%7c" + $args[3] + "%3a" + $args[4] + "&metricValue=" + $args[5])
Write-Host $metricURL
[net.WebClient] $wc = new-object net.WebClient
$probe = $wc.downloadData($metricURL)

# Write-Host $_.Name " = " $_.Status